/*
 * Decompiled with CFR 0.152.
 */
import bean.PatternMethods;
import control.FindPatterns;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Vector;

public class Main {
    public static void main(String[] args) {
        String pathTraces = args[0];
        int minLength = Integer.valueOf(args[1]);
        int maxLength = Integer.valueOf(args[2]);
        File sourceFolder = new File(pathTraces);
        int i = minLength;
        while (i <= maxLength) {
            try {
                File[] toAnalyze;
                File output = new File(String.valueOf(pathTraces) + "/patternsIdentified_length_" + i);
                PrintWriter pw = new PrintWriter(output);
                pw.println("Pattern,Instances,AvgConsumption,Median,Max,Min");
                File provenance = new File(String.valueOf(pathTraces) + "/provenance_length_" + i);
                PrintWriter pwProvenance = new PrintWriter(provenance);
                pwProvenance.println("Pattern,Traces");
                Vector<PatternMethods> allPatterns = new Vector<PatternMethods>();
                File[] fileArray = toAnalyze = sourceFolder.listFiles();
                int n = toAnalyze.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    String fileName = f.getName();
                    if (fileName.endsWith(".calls")) {
                        String text = Main.readFile(f.getAbsolutePath());
                        Vector<PatternMethods> patterns = FindPatterns.getPatternsGivenLength(i, text, fileName);
                        for (PatternMethods p : patterns) {
                            if (!allPatterns.contains(p)) {
                                allPatterns.add(p);
                                continue;
                            }
                            int index = allPatterns.indexOf(p);
                            ((PatternMethods)allPatterns.elementAt(index)).addEnergyConsumption(p.getEnergy().elementAt(0));
                            ((PatternMethods)allPatterns.elementAt(index)).addFileContainingIt(fileName);
                        }
                    }
                    System.gc();
                    System.gc();
                    System.gc();
                    System.gc();
                    ++n2;
                }
                System.gc();
                Collections.sort(allPatterns);
                System.gc();
                for (PatternMethods p : allPatterns) {
                    pw.println(p.toString());
                    pwProvenance.println(String.valueOf(p.getPattern()) + "," + p.listFilesContainingIt());
                }
                pw.close();
                pwProvenance.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private static String readFile(String nomeFile) throws IOException {
        FileInputStream is = null;
        InputStreamReader isr = null;
        StringBuffer sb = new StringBuffer();
        char[] buf = new char[1024];
        try {
            int len;
            is = new FileInputStream(nomeFile);
            isr = new InputStreamReader(is);
            while ((len = isr.read(buf)) > 0) {
                sb.append(buf, 0, len);
            }
            System.gc();
            String string = sb.toString();
            return string;
        }
        finally {
            if (isr != null) {
                isr.close();
            }
        }
    }
}

