/*
 * Decompiled with CFR 0.152.
 */
package bean;

import java.util.Collections;
import java.util.Vector;

public class PatternMethods
implements Comparable {
    private String pattern = "";
    private Vector<Double> energy;
    private Vector<String> tracesContainingIt;

    public PatternMethods() {
        this.setEnergy(new Vector<Double>());
        this.setTracesContainingIt(new Vector<String>());
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public int compareTo(Object o) {
        Double totalThis = 0.0;
        Double totalToCompare = 0.0;
        for (Double d : this.getEnergy()) {
            totalThis = totalThis + d;
        }
        totalThis = totalThis / (double)this.energy.size();
        for (Double d : ((PatternMethods)o).getEnergy()) {
            totalToCompare = totalToCompare + d;
        }
        totalToCompare = totalToCompare / (double)((PatternMethods)o).getEnergy().size();
        return totalToCompare.compareTo(totalThis);
    }

    public boolean equals(Object o) {
        PatternMethods toCompare = (PatternMethods)o;
        return this.pattern.equals(toCompare.getPattern());
    }

    public Vector<Double> getEnergy() {
        return this.energy;
    }

    public void setEnergy(Vector<Double> energy) {
        this.energy = energy;
    }

    public void addEnergyConsumption(Double energyConsumption) {
        this.energy.add(energyConsumption);
    }

    public void addFileContainingIt(String fileName) {
        if (!this.tracesContainingIt.contains(fileName)) {
            this.tracesContainingIt.add(fileName);
        }
    }

    public String toString() {
        String toReturn = this.getPattern();
        double average = 0.0;
        double max = 0.0;
        double min = 0.0;
        double median = 0.0;
        Collections.sort(this.energy);
        if (this.energy.size() == 1) {
            average = this.energy.elementAt(0);
            max = this.energy.elementAt(0);
            min = this.energy.elementAt(0);
            median = this.energy.elementAt(0);
        } else {
            min = this.energy.elementAt(0);
            max = this.energy.elementAt(this.energy.size() - 1);
            median = this.energy.elementAt(this.energy.size() / 2);
            double sum = 0.0;
            for (Double d : this.energy) {
                sum += d.doubleValue();
            }
            average = sum / (double)this.energy.size();
        }
        toReturn = String.valueOf(toReturn) + "," + this.energy.size() + "," + average + "," + median + "," + max + "," + min;
        return toReturn;
    }

    public Vector<String> getTracesContainingIt() {
        return this.tracesContainingIt;
    }

    public void setTracesContainingIt(Vector<String> tracesContainingIt) {
        this.tracesContainingIt = tracesContainingIt;
    }

    public String listFilesContainingIt() {
        String result = "";
        for (String file : this.tracesContainingIt) {
            result = String.valueOf(result) + file + ";";
        }
        return result;
    }
}

