/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tools.shell;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;

public class ShellContextFactory
extends ContextFactory {
    private boolean strictMode;
    private int languageVersion;
    private int optimizationLevel;
    private ErrorReporter errorReporter;

    @Override
    protected boolean hasFeature(Context cx, int featureIndex) {
        switch (featureIndex) {
            case 8: 
            case 9: {
                return this.strictMode;
            }
        }
        return super.hasFeature(cx, featureIndex);
    }

    @Override
    protected void onContextCreated(Context cx) {
        cx.setLanguageVersion(this.languageVersion);
        cx.setOptimizationLevel(this.optimizationLevel);
        if (this.errorReporter != null) {
            cx.setErrorReporter(this.errorReporter);
        }
        super.onContextCreated(cx);
    }

    public void setStrictMode(boolean flag) {
        this.checkNotSealed();
        this.strictMode = flag;
    }

    public void setLanguageVersion(int version) {
        Context.checkLanguageVersion(version);
        this.checkNotSealed();
        this.languageVersion = version;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        Context.checkOptimizationLevel(optimizationLevel);
        this.checkNotSealed();
        this.optimizationLevel = optimizationLevel;
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        if (errorReporter == null) {
            throw new IllegalArgumentException();
        }
        this.errorReporter = errorReporter;
    }
}

