#include <unistd.h>

#include "mu.h"
#include "xpthread.h"

static int val = 0;
static pthread_mutex_t mtx = PTHREAD_MUTEX_INITIALIZER;
static pthread_cond_t cond = PTHREAD_COND_INITIALIZER;


static void *
worker_fn(void *arg)
{
    MU_UNUSED(arg);

    sleep(2);

    xpthread_mutex_lock(&mtx);
    val = 1;
    xpthread_mutex_unlock(&mtx);
    xpthread_cond_signal(&cond);

    sleep(2);

    return NULL;
}


int
main(void)
{
    pthread_t thread;

    xpthread_create(&thread, NULL, worker_fn, NULL);


    xpthread_mutex_lock(&mtx);
    while (val == 0)
        xpthread_cond_wait(&cond, &mtx);

    printf("val = %d\n", val);

    xpthread_mutex_unlock(&mtx);


    xpthread_join(thread, NULL);

    return 0;
}
