#include <sys/types.h>
#include <sys/stat.h>

#include <errno.h>
#include <stdio.h>
#include <unistd.h>

#include "mu.h"

/* 
 * On success, return the file size.
 * On error, return a negative errno value.
 */
static ssize_t
file_size(const char *path)
{
    int ret;
    struct stat statbuf;

    ret = stat(path, &statbuf);
    return ret == -1 ? -errno : statbuf.st_size;
}


int
main(int argc, char *argv[])
{
    int ret = 0;
    ssize_t size;
    char *path;

    if (argc != 2)
        mu_die("Usage: %s PATH", argv[0]);

    path = argv[1];

    size = file_size(path);
    if (size < 0) {
        ret = 1;
        mu_stderr_errno(-size, "%s", path);
    } else {
        printf("%zd\n", size);
    }

    return ret;
}
