#include <sys/types.h>

#include <errno.h>
#include <stdio.h>
#include <unistd.h>

#include "mu.h"

/* 
 * On success, return 0.
 * On error, return a negative errno value.
 */
static int
set_file_size(const char *path, long size)
{
    int ret;

    ret = truncate(path, size);
    return ret == -1 ? -errno : 0;
}


/*
 * On success, return 0.
 * On error, return 1.
 */
int
main(int argc, char *argv[])
{
    int ret = 0;
    char *path;
    long size;

    if (argc != 3)
        mu_die("Usage: %s PATH SIZE", argv[0]);

    path = argv[1];
    ret = mu_str_to_long(argv[2], 10, &size);
    if (ret != 0) {
        ret = 1;
        mu_stderr("invalid SIZE: \"%s\"", argv[2]);
        goto out;
    }

    if (size < 0) {
        ret = 1;
        mu_stderr("SIZE can't be negative");
        goto out;
    }

    size = set_file_size(path, size);
    if (size < 0) {
        ret = 1;
        mu_stderr_errno(-size, "%s", path);
    }

out:
    return ret;
}
