#include <sys/types.h>

#include <errno.h>
#include <dirent.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mu.h"


static int
list_dir(const char *dirpath)
{
    int ret = 0;
    DIR *d = NULL;
    struct dirent *dirent = NULL;

    d = opendir(dirpath);
    if (d == NULL) {
        ret = -errno;
        mu_stderr_errno(errno, "opendir(\"%s\")", dirpath);
        goto out;
    }

    while (1) {
        errno = 0;
        dirent = readdir(d);
        if (dirent == NULL)
            break;

        if (strcmp(dirent->d_name, ".") == 0 || strcmp(dirent->d_name, "..") == 0)
            continue;

        printf("%s\n", dirent->d_name);
    }

    if (errno != 0)
        mu_stderr_errno(errno, "readdir(\"%s\")", dirpath);

out:
    if (d != NULL)
        closedir(d);

    return ret;
}


int
main(int argc, char *argv[])
{
    int ret;
    const char *dirpath;

    if (argc == 1)
        dirpath = ".";
    else if (argc == 2)
        dirpath = argv[1];
    else
        mu_die("Usage: dir [DIR]\n");

    ret = list_dir(dirpath);

    return ret == 0 ? EXIT_SUCCESS : EXIT_FAILURE;
}
