use clap::Parser;
use std::path::PathBuf;

#[derive(Parser, Debug)]
#[command(name = "sgrep", about = "A simplified version of grep")]
struct Args {
    /// Ignore cases distinctions (-i, --ignore-case)
    #[arg(short = 'i', long = "ignore-case")]
    ignore_case: bool,

    /// Stop aftert NUM matching lines (-m, --max-count)
    #[arg(short = 'm', long = "max-count")]
    max_count: Option<u32>,

    /// The search pattern (positional argument)
    pattern: String,

    /// The input file to read (optional positional)
    file: Option<PathBuf>
}

fn main() {
    let args = Args::parse();

    println!("ignore-case: {}", args.ignore_case);
    match args.max_count {
        Some(n) => println!("max-count: {}", n),
        None => println!("max-count not specified."),
    }

    println!("pattern: {:?}", args.pattern);

    if let Some(file) = &args.file {
        println!("file: {:?}", file);
    } else {
        println!("file: <using stdin>");
    }
}
