#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <unistd.h>

#include "mu.h"


/* UNSAFE: this handler uses a non-async-signal-safe function (printf) */
static void
handler(int sig)
{
    printf("[caught %s]\n", strsignal(sig));

    return;
}


int
main(void)
{
    int i;
    
    if (signal(SIGUSR1, handler) == SIG_ERR)
        mu_die_errno(errno, "signal");

    for (i = 0; ; i++) {
        printf("%d\n", i);
        sleep(2);
        raise(SIGUSR1);
    }

    return 0;
}
