#include <errno.h>
#include <signal.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "mu.h"

/* UNSAFE: this handler uses a non-async-signal-safe function (printf) */
static void
handler(int sig)
{
    (void)sig;

    printf("[caught SIGINT]\n");

    return;
}


int
main(void)
{
    int i;
    struct sigaction act;

    memset(&act, 0x00, sizeof(act));
    sigemptyset(&act.sa_mask);
    act.sa_handler = handler;

    if (sigaction(SIGINT, &act, NULL) == -1)
        mu_die_errno(errno, "sigaction");

    for (i = 0; ; i++) {
        printf("%d\n", i);
        sleep(2);
    }

    return 0;
}
