#include <errno.h>
#include <signal.h>

#include "mu.h"


int
main(int argc, char *argv[])
{
    int ret;
    pid_t pid;
    int signum, val;
    union sigval sv;

    if (argc != 4)
        mu_die("Usage: %s PID SIGNUM VAL", argv[0]);

    ret = mu_str_to_int(argv[1], 10, &pid);
    if (ret != 0)
        mu_die_errno(-ret, "bad value for PID: \"%s\"", argv[1]);
    ret = mu_str_to_int(argv[2], 10, &signum);
    if (ret != 0)
        mu_die_errno(-ret, "bad value for SIGNUM: \"%s\"", argv[2]);
    ret = mu_str_to_int(argv[3], 10, &val);
    if (ret != 0)
        mu_die_errno(-ret, "bad value for VAL: \"%s\"", argv[3]);

    sv.sival_int = val;
    ret = sigqueue(pid, signum, sv);
    if (ret == -1)
        mu_die_errno(errno, "sigqueue");

    return 0;
}
