#include <sys/types.h>
#include <sys/socket.h>

#include <arpa/inet.h>

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>

#include "common.h"
#include "mu.h"


static void
repl(int sk, struct sockaddr_in *server)
{
    ssize_t len_ret = 0;
    size_t len = 0;
    char *line = NULL;
    char buffer[BUF_SIZE] = { 0 };
    int err;

    while (1) {
        printf("> ");
        len_ret = getline(&line, &len, stdin);
        if (len_ret == -1)
            break;

        err = sendto(sk, line, len_ret, 0, (struct sockaddr *)server, sizeof(*server));
        if (err == -1)
            mu_die_errno(errno, "sendto");

        memset(buffer, 0x00, sizeof(buffer));
        err = recvfrom(sk, buffer, sizeof(buffer) - 1, 0, NULL, NULL);
        if (err == -1)
            mu_die_errno(errno, "recvfrom");

        printf("%s", buffer);
    }
}


int
main(int argc, char *argv[])
{
    int sk;
    struct sockaddr_in server;

    if (argc != 3)
        mu_die("Usage: %s IP PORT", argv[0]);

    sk = socket(AF_INET, SOCK_DGRAM, 0);
    if (sk == -1)
        mu_die_errno(errno, "socket");

    mu_init_sockaddr_in(&server, argv[1], argv[2]);

    repl(sk, &server);

    return 0;
}
