#include <sys/types.h>
#include <sys/socket.h>

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <stdint.h>
#include <unistd.h>

#include "mu.h"


#define BUF_SIZE 128
#define BACKLOG 5


static void
serve_forever(int sk)
{
    char buf[BUF_SIZE] = { 0 };
    struct sockaddr_in peer;
    socklen_t addrlen;
    ssize_t n, i;
    char peer_ip[INET_ADDRSTRLEN] = { 0 };
    uint16_t peer_port;

    while (1) {
        addrlen = sizeof(peer);
        n = recvfrom(sk, buf, sizeof(buf), 0, (struct sockaddr *)&peer, &addrlen);
        if (n == -1)
            mu_die_errno(errno, "recvfrom");

        if (inet_ntop(AF_INET, &peer.sin_addr, peer_ip, sizeof(peer_ip)) == NULL)
            mu_die_errno(errno, "inet_ntop");
        peer_port = ntohs(peer.sin_port);

        printf("msg from %s:%u\n", peer_ip, peer_port);

        for (i = 0; i < n; i++)
            buf[i] = toupper(buf[i]);

        n = sendto(sk, buf, n, 0, (struct sockaddr *)&peer, sizeof(peer));
        if (n == -1)
            mu_die_errno(errno, "sendto");
    }
}


static int
udp_server_create(const char *ip, const char *port)
{
    struct sockaddr_in sa;
    int sk;
    int err;

    sk = socket(AF_INET, SOCK_DGRAM, 0);
    if (sk == -1)
        mu_die_errno(errno, "socket");

    mu_init_sockaddr_in(&sa, ip, port);
    err = bind(sk, (struct sockaddr *)&sa, sizeof(sa));
    if (err == -1)
        mu_die_errno(errno, "bind");

    return sk;
}


int
main(int argc, char *argv[])
{
    int sk;

    if (argc != 3)
        mu_die("Usage: %s IP PORT", argv[0]);

    sk = udp_server_create(argv[1], argv[2]);
    serve_forever(sk);

    return 0;
}
