#include <pthread.h>
#include <stdio.h>
#include <unistd.h>

#include "mu.h"


struct data {
    int val;
    pthread_mutex_t lock;
};

static struct data *a, *b;


static struct data *
data_new(int val)
{
    struct data *self = mu_zalloc(sizeof(*self));

    self->val = val;
    pthread_mutex_init(&self->lock, NULL);

    return self;
}


static void
data_free(struct data *self)
{
    pthread_mutex_destroy(&self->lock);
    free(self);
}


static void *
add_ab(void *arg)
{
    int err;

    MU_UNUSED(arg);

    err = pthread_mutex_lock(&a->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_lock(a)", __func__);

    sleep(1);

    err = pthread_mutex_lock(&b->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_lock(b)", __func__);

    printf("%d + %d = %d\n", a->val, b->val, a->val + b->val);

    err = pthread_mutex_unlock(&b->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_unlock(b)", __func__);

    err = pthread_mutex_unlock(&a->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_unlock(a)", __func__);

    return NULL;
}


static void *
add_ba(void *arg)
{
    int err;

    MU_UNUSED(arg);

    err = pthread_mutex_lock(&b->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_lock(b)", __func__);

    sleep(1);

    err = pthread_mutex_lock(&a->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_lock(a)", __func__);

    printf("%d + %d = %d\n", a->val, b->val, a->val + b->val);

    err = pthread_mutex_unlock(&a->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_unlock(a)", __func__);

    err = pthread_mutex_unlock(&b->lock);
    if (err != 0)
        mu_die_errno(err, "%s: pthread_mutex_unlock(b)", __func__);

    return NULL;
}


int
main(void)
{
    pthread_t t_ab, t_ba;
    int err;

    /* init */
    a = data_new(4);
    b = data_new(5);;


    /* spawn threads */
    err = pthread_create(&t_ab, NULL, add_ab, NULL);
    if (err != 0)
        mu_die_errno(err, "pthread_create");

    err = pthread_create(&t_ba, NULL, add_ba, NULL);
    if (err != 0)
        mu_die_errno(err, "pthread_create");


    /* wait for threads to terminate */
    err = pthread_join(t_ab, NULL);
    if (err != 0)
        mu_die_errno(err, "pthread_create");

    err = pthread_join(t_ba, NULL);
    if (err != 0)
        mu_die_errno(err, "pthread_create");


    /* cleanup */
    data_free(a);
    data_free(b);

    return 0;
}
