#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "mu.h"


struct add_op {
    unsigned int op_id;
    int x;
    int y;
    int res;
};


static struct add_op *
add_op_new(int op_id, int x, int y)
{
    MU_NEW(add_op, op);

    op->op_id = op_id;
    op->x = x;
    op->y = y;

    return op;
}


static void
add_op_free(struct add_op *op)
{
    free(op);
}


static void *
add_func(void *arg)
{
    struct add_op *op = arg;

    op->res = op->x + op->y;

    return op;;
}


int
main(int argc, char *argv[])
{
    int err;
    struct add_op *op;
    unsigned int i, num_threads;
    pthread_t *threads = NULL;

    if (argc != 2)
        mu_die("Usage: %s NUM_THREADS", argv[0]);

    err = mu_str_to_uint(argv[1], 10, &num_threads);
    if (err != 0)
        mu_die("invalid value for NUM_THREADS");

    threads = mu_calloc(num_threads, sizeof(pthread_t));

    srand(time(NULL));
    for (i = 0; i < num_threads; i++) {
        op = add_op_new(i, rand() % 100, rand() % 100);
        err = pthread_create(&threads[i], NULL, add_func, op);
        if (err != 0)
            mu_die_errno(err, "pthread_create");
        printf("main: spawned thread %u: %d + %d\n", op->op_id, op->x, op->y);
    }

    for (i = 0; i < num_threads; i++) {
        err = pthread_join(threads[i], (void **)&op);
        if (err != 0)
            mu_die_errno(err, "pthread_join");

        printf("main: joined thread %u: %d + %d = %d\n",
                op->op_id, op->x, op->y, op->res);
        add_op_free(op);
    }

    free(threads);

    return 0;
}
