#include <pthread.h>

#include "mu.h"

int
main(void)
{
    int err;
    pthread_mutex_t mtx;

    /* create mutex */

    err = pthread_mutex_init(&mtx, NULL);
    if (err != 0)
        mu_die_errno(err, "pthread_mutex_init");


    /* double lock */

    err = pthread_mutex_lock(&mtx);
    if (err != 0)
        mu_die_errno(err, "pthread_mutex_lock #1");

    err = pthread_mutex_lock(&mtx);
    if (err != 0)
        mu_die_errno(err, "pthread_mutex_lock #2");



    err = pthread_mutex_unlock(&mtx);
    if (err != 0)
        mu_die_errno(err, "pthread_mutex_unlock");

    err = pthread_mutex_destroy(&mtx);
    if (err != 0)
        mu_die_errno(err, "pthread_mutex_destroy");

    return 0;
}
