#include <pthread.h>
#include <stdio.h>

#include "mu.h"


static int g = 0;


static void *
thread_func(void *arg)
{
    int num_loops = *((int *)arg);
    int i, tmp;

    for (i = 0; i < num_loops; i++) {
        tmp = g;
        tmp++;
        g = tmp;
    }

    return NULL;
}


int
main(int argc, char *argv[])
{
    pthread_t t1, t2;
    int num_loops;
    int err;

    if (argc != 2)
        mu_die("Usage: %s NUM_LOOPS", argv[0]);

    err = mu_str_to_int(argv[1], 10, &num_loops);
    if (err != 0)
        mu_die("invalid value for NUM_LOOPS");

    /* spawn the threads */
    err = pthread_create(&t1, NULL, thread_func, &num_loops);
    if (err != 0)
        mu_die_errno(err, "pthread_create");

    err = pthread_create(&t2, NULL, thread_func, &num_loops);
    if (err != 0)
        mu_die_errno(err, "pthread_create");

    /* wait for threads to complete */
    err = pthread_join(t1, NULL);
    if (err != 0)
        mu_die_errno(err, "pthread_join");
    
    err = pthread_join(t2, NULL);
    if (err != 0)
        mu_die_errno(err, "pthread_join");

    printf("g = %d (expected %d)\n", g, num_loops * 2);

    return 0;
}
