package main

import (
	"flag"
	"fmt"
	"os"

	"sodoh/internal/mu"
)

const usage = `Usage: client [options] QNAME

Send a simplified Oblivious DNS (ODoH) request.

positional arguments:
  QNAME
    The query name (domainname) to resolve.
    
options:
  -ca-cert CA_CERT
    The certificate file for the CA that signed the TLS certificate
    for the proxy.

    Default: ca.crt

  -target-cert TARGET_CERT
    The certificate file for the target.  The client uses the
    certificate's public key to hybrid encrypt the DNS request.

    Default: target.crt

  -proxy PROXY_HOST
    The proxy host.  This has the form host[:port], where host can be either
    a domainname or an IP address.

    Default: 127.0.0.1:8053

  -target TARGET_HOST
    The target host.  This has the form host[:port], where host can be either
    a domainname or an IP address.

    Default: 127.0.0.1:8054

  -help
    Display this usage statement and exit.

examples:
  $ ./client -ca-cert assets/ca.crt -target-cert assets/target.crt www.cs.wm.edu
`

type Options struct {
	// positional
	qname string
	// options
	caCertFile     string
	targetCertFile string
	proxyHost      string
	targetHost     string
}

func printUsage() {
	fmt.Fprintf(os.Stderr, "%s", usage)
}

func parseOptions() *Options {
	options := Options{}

	flag.Usage = printUsage
	flag.StringVar(&options.caCertFile, "ca-cert", "ca.crt", "")
	flag.StringVar(&options.targetCertFile, "target-cert", "target.crt", "")
	flag.StringVar(&options.proxyHost, "proxy", "127.0.0.1:8053", "")
	flag.StringVar(&options.targetHost, "target", "127.0.0.1:8054", "")

	flag.Parse()

	if flag.NArg() != 1 {
		mu.Die("expected one positional argument but got %d", flag.NArg())
	}

	options.qname = flag.Arg(0)

	return &options
}

func main() {
	options := parseOptions()

	// TODO: delete the following line and implement the rest
	mu.UNUSED(options)
}
