package main

import (
	"flag"
	"fmt"
	"os"

	"sodoh/internal/mu"
)

const usage = `Usage: proxy [options] [HOST]:PORT

Proxy server for Oblivious DNS (ODoH).

positional arguments
  [HOST]:PORT

  A "host:port" address that the proxy listens on for HTTPS requests.

options:
  -cert TLS_CERT
    The TLS certificate file for the proxy.

    Default: proxy.crt

  -key TLS_PRIVATE_KEY
    The TLS private key for the proxy.

    Default: proxy.key

  -ca-cert CA_CERT
    The certificate file for the CA that signed the TLS certificate
    for the target.

    Default: ca.crt

  -help
    Display this usage statement and exit.

examples:
$ ./proxy -ca-cert assets/ca.crt -cert assets/proxy.crt -key assets/proxy.key 127.0.0.1:8053
`

type Options struct {
	// positional
	hostport string
	// options
	caCertFile string
	certFile   string
	keyFile    string
}

func printUsage() {
	fmt.Fprintf(os.Stderr, "%s", usage)
}

func parseOptions() *Options {
	options := Options{}

	flag.Usage = printUsage
	flag.StringVar(&options.caCertFile, "ca-cert", "ca.crt", "")
	flag.StringVar(&options.certFile, "cert", "proxy.crt", "")
	flag.StringVar(&options.keyFile, "key", "proxy.key", "")

	flag.Parse()

	if flag.NArg() != 1 {
		mu.Die("expected one positional argument but got %d", flag.NArg())
	}

	options.hostport = flag.Arg(0)

	return &options
}

func main() {
	options := parseOptions()

	// TODO: delete the following line and implement the rest
	mu.UNUSED(options)
}
