package main

import (
	"flag"
	"fmt"
	"os"

	"sodoh/internal/mu"
)

const usage = `Usage: target [options] [HOST]:PORT

Target server for Oblivious DNS (ODoH).

positional arguments
  [HOST]:PORT

  A "host:port" address that the target listens on for HTTPS requests.

options:
  -cert TLS_CERT
    The TLS certificate file for the target.

    Default: target.crt

  -key TLS_PRIVATE_KEY
    The TLS private key for the target.

    Default: target.key

  -help
    Display this usage statement and exit.

examples:
$ ./target -cert assets/target.crt -key assets/target.key 127.0.0.1:8054
`

type Options struct {
	// positional
	hostport string
	// options
	certFile string
	keyFile  string
}

func printUsage() {
	fmt.Fprintf(os.Stderr, "%s", usage)
}

func parseOptions() *Options {
	options := Options{}

	flag.Usage = printUsage
	flag.StringVar(&options.certFile, "cert", "proxy.crt", "")
	flag.StringVar(&options.keyFile, "key", "proxy.key", "")

	flag.Parse()

	if flag.NArg() != 1 {
		mu.Die("expected one positional argument but got %d", flag.NArg())
	}

	options.hostport = flag.Arg(0)

	return &options
}

func main() {
	options := parseOptions()

	// TODO: delete the following line and implement the rest
	mu.UNUSED(options)
}
