package main

import (
    "os"
	"flag"
	"fmt"
    "log"
)

const usage = `Usage: sget [options] HOST:PORT REQUEST

sget client

positional arguments
  HOST:PORT
    The host:port of the server to connect to.  HOST can be an IP address or a
    domain name.

  REQUEST
    The name of the file to download.

options:

    ...
`

type Options struct {
	// positional
	hostport string
	request  string

	// optional
	certFile   string
	keyFile    string
	caCertFile string
	outFile    string
}


func printUsage() {
	fmt.Fprintf(os.Stderr, "%s", usage)
}

func parseOptions() *Options {
	opts := Options{}

	flag.Usage = printUsage
	flag.StringVar(&opts.certFile, "cert", "", "")
	flag.StringVar(&opts.keyFile, "key", "", "")
	flag.StringVar(&opts.caCertFile, "ca-cert", "", "")
	flag.StringVar(&opts.outFile, "out", "", "")
	flag.Parse()

    // TODO: validate the options

	if flag.NArg() != 2 {
		log.Fatalf("expected two positional arguments but got %d", flag.NArg())
	}
	opts.hostport = flag.Arg(0)
	opts.request = flag.Arg(1)

	return &opts
}

func main() {
	opts := parseOptions()

    fmt.Printf("hostport: %q\n", opts.hostport)
    fmt.Printf("request: %q\n", opts.request)
    fmt.Printf("certFile: %q\n", opts.certFile)
    fmt.Printf("keyFile: %q\n", opts.keyFile)
    fmt.Printf("caCertFile: %q\n", opts.caCertFile)
    fmt.Printf("outFile: %q\n", opts.outFile)
}
