package main

import (
	"bufio"
	"flag"
	"fmt"
	"io"
	"net"
	"os"

	"ucase_tcp/internal/mu"
)

const shortUsage = "Usage: client HOSTPORT"
const usage = `Usage: client [options] HOSTPORT

TCP ucase client

HOSTPORT
  The server's IP address and port number to connect to.

options:
  -h, -help
    Show this usage statement and exit.

examples:
$ ./client 127.0.0.1:12345
`

func printUsage() {
	fmt.Print(usage)
}

func repl(conn net.Conn) {
	defer conn.Close()

	scanner := bufio.NewScanner(os.Stdin)
	connBufReader := bufio.NewReader(conn)
	for scanner.Scan() {
		s := scanner.Text()
		fmt.Printf("sending %q\n", s)
		_, err := io.WriteString(conn, s+"\n")
		if err != nil {
			mu.Die("error: socket write failed: %v", err)
		}

		text, err := connBufReader.ReadString('\n')
		fmt.Print(text)
		if err != nil && err != io.EOF {
			mu.Die("error: socket read failed: %v", err)
			break
		}
	}

	if err := scanner.Err(); err != nil {
		mu.Die("error: stdin read failed: %v", err)
	}
}

func createConn(hostport string) net.Conn {
	conn, err := net.Dial("tcp", hostport)
	if err != nil {
		mu.Die("error: %v", err)
	}
	return conn
}

func main() {
	flag.Usage = printUsage
	flag.Parse()

	if flag.NArg() != 1 {
		mu.Die(shortUsage)
	}

	hostport := flag.Arg(0)

	conn := createConn(hostport)
	repl(conn)
}
