CC = g++        
C = gcc
F = g77
CFLAGS = -g -Wall
FFLAGS =
FLIBS = -L/usr/local/freeware/lib/gcc-lib/mips-sgi-irix6.2/2.95.2 

OBJ = MyMain.o
LIBS = -lgcc
MYLIBS = libsearch.a
LIBOBJ = CoordinateSearch.o CompassSearch.o DirectSearch.o \
         EdHJSearch.o HJSearch.o Hybrid_NMSearch.o NLessSearch.o \
         NMSearch.o objective.o PatternSearch.o SHHSearch.o \
         SimplexSearch.o SMDSearch.o migrate.o direct.o

all:  search

fresh: clean all

freshlib: clean libsearch.a

libsearch.a: $(LIBOBJ)
	ar -rv libsearch.a $(LIBOBJ)

search: rmfor $(OBJ) $(MYLIBS) vec.h cppmat.h
	$(CC) $(CFLAGS) -o MySearch $(OBJ) $(MYLIBS) $(LIBS)

rmfor:
	rm -f direct.o MyMain.o

direct.o: direct.c
	${C} -c ${CFLAGS} direct.c

MyMain.o: MyMain.c
	${C} -c ${CFLAGS} MyMain.c

.cc.o: vec.h cppmat.h
	${CC} -c ${CFLAGS} -o $@ $<
.SUFFIXES: .cc .o

clean: 
	rm -f *.o libsearch.a MySearch


