CC = g++        
F = g77
CFLAGS = -g -Wall
FFLAGS =
FLIBS = -L/usr/local/freeware/lib/gcc-lib/mips-sgi-irix6.2/2.95.2

OBJ = MyMain.o
LIBS = -lg2c
MYLIBS = libsearch.a
LIBOBJ = CoordinateSearch.o CompassSearch.o DirectSearch.o \
         EdHJSearch.o HJSearch.o Hybrid_NMSearch.o NLessSearch.o \
         NMSearch.o objective.o PatternSearch.o SHHSearch.o \
         SimplexSearch.o SMDSearch.o migrate.o direct.o

all:  search

fresh: clean all

freshlib: clean libsearch.a

libsearch.a: $(LIBOBJ)
	ar -rv libsearch.a $(LIBOBJ)

search: rmc $(OBJ) $(MYLIBS) vec.h cppmat.h
	$(CC) $(CFLAGS) -o MySearch $(OBJ) $(MYLIBS) $(FLIBS) $(LIBS)

rmc:
	rm -f direct.o MyMain.o

direct.o: direct.f
	${F} -c ${FFLAGS} $(FLIBS) direct.f

MyMain.o: MyMain.f
	${F} -c ${FFLAGS} $(FLIBS) MyMain.f

.cc.o: vec.h cppmat.h
	${CC} -c ${CFLAGS} -o $@ $<
.SUFFIXES: .cc .o

clean: 
	rm -f *.o libsearch.a MySearch


