c---------------------------------------------------------------------
c     These subroutines are part of the library "libsearch.a".
c     To compile and link with them:
c       g77 -c YourMain.f (whatever you want to call it)
c       g++ -o name_me YourMain.o libsearch.a -lg2c
c         (Older EGCS: -lf2c instead)        
c---------------------------------------------------------------------
c
      subroutine pattrn(choice, obj, n, x, step1, step2, maxf, 
     c                  istat, aux, iaux)
c---------------------------------------------------------------------
c     This subroutine indirectly calls C++ libraries to perform 
c     a pattern search given a user-defined objective function
c
c     Arguments:
c        choice - the search type
c                 1 = Coordinate Search
c                 2 = Compass Search
c                 3 = NLess Search
c                 4 = Hooke and Jeeves
c                 5 = Hooke and Jeeves (edited by E. Dolan)
c        obj    - the subroutine which contains the objective function;
c                 The subroutine must have the following signature:
c                 obj(x,f,n) - where x is the array of x values to 
c                 evaluate, f holds the function evaluation, and n is
c                 the dimension of the problem. Be sure to declare the
c                 subroutine as external before passing it as an argument
c                 to pattrn()
c        n      - dimension of the problem
c        x      - double precision x (or array of x), which is the
c                 starting point of the objective function
c        step1  - starting step length (If -1, a default of 0.25 is used)
c        step2  - ending step length (If -1, a default of 10E-8 is used)
c        maxf   - the maximum allowable number of function evaluations
c                 Set to -1 if no maximum is desired.
c        istat  - completion status (always 1, since search algorithms
c                 have no criteria to stop them from going indefinitely)
c        aux    - the array of size n+2 returned from the library; the 
c                 first value is the final step length, the second is 
c                 the minimum function evaluation and the final n 
c                 elements are the x values which correspond
c        iaux   - returns the number of function evaluations required
c
c---------------------------------------------------------------------
c     Declare the external routines
      external coord, compss, nless, hj, edhj, obj
c     Declare the arguments
      integer choice, n, maxf
      double precision x(*), step1, step2, aux(*)
c
      if (choice.eq.1) then
         call coord(n, x, step1, step2, maxf, istat, 
     c        aux, iaux, obj)
      else if (choice.eq.2) then
         call compss(n, x, step1, step2, maxf, istat, 
     c        aux, iaux, obj)
      else if (choice.eq.3) then
         call nless(n, x, step1, step2, maxf, istat, 
     c        aux, iaux, obj)
      else if (choice.eq.4) then
         call hj(n, x, step1, step2, maxf, istat, 
     c        aux, iaux, obj)
      else if (choice.eq.5) then
         call edhj(n, x, step1, step2, maxf, istat, 
     c        aux, iaux, obj)
      else
         write(*,10)
      endif
  10  format('\nThat was not a valid method\n')
      return
      end

      subroutine shh(obj, n, x, right, step1, step2, maxf, stddev, 
     c     istat, aux, iaux)
c---------------------------------------------------------------------
c     This subroutine implements a simplex search based on the
c     method of Spendley, Hext, and Himsworth given a user-defined 
c     objective function
c
c     Arguments:
c        obj    - the subroutine which contains the objective function;
c                 The subroutine must have the following signature:
c                 obj(x,f,n) - where x is the array of x values to 
c                 evaluate, f holds the function evaluation, and n is
c                 the dimension of the problem. Be sure to declare the
c                 subroutine as external before passing it as an argument
c                 to shh()
c        n      - dimension of the problem
c        x      - double precision x (or array of x), which is the
c                 starting point of the objective function
c        right  - a logical; If true, the user wants a right simplex.
c                 If false, the user wants a regular simplex. 
c        step1  - the starting edgelengths of the simplex. If the
c                 simplex is regular, only one value is required.
c                 An array of n edgelengths is required for a right 
c                 simplex. Set the first element to -1 to use the
c                 default values of 2.0 for the edgelengths.
c        step2  - ending step length (If -1, a default of 10E-8 is used)  
c        maxf   - the maximum allowable number of function evaluations
c                 Set to -1 if no maximum is desired.
c        stddev - a logical which tells the library whether or not to
c                 use the standard deviation as a stopping criterion.
c                 If true, program will terminate if standard deviation
c                 is less than step2. If false, program will terminate 
c                 when delta is less than step2.
c                 See Direct Search class design document for more info. 
c        istat  - completion status (always 1, since search algorithms
c                 have no criteria to stop them from going indefinitely)
c        aux    - the array of size n+2 returned from the library; the 
c                 first value is the final step length, the second is 
c                 the minimum function evaluation and the final n 
c                 elements are the x values which correspond
c        iaux   - returns the number of function evaluations required
c
c---------------------------------------------------------------------
c     Declare the external routines
      external shhsch, obj
c     Declare the arguments
      integer n, maxf, stp
      double precision x(*), step1(*), step2, aux(*)
      logical right, stddev
c
      if (right) then
         iright = 1
      else
         iright = 0
      endif
      if (stddev) then
         stp = 1
      else
         stp = 0
      endif
      call shhsch(n, x, iright, step1, step2, maxf, stp, istat, 
     c     aux, iaux, obj)
      return
      end
c
      subroutine nm(obj, n, x, right, sigma, alpha, beta, gamma, step1, 
     c     step2, maxf, stddev, istat, aux, iaux)
c---------------------------------------------------------------------
c     This subroutine implements a simplex search based on the
c     method of Nelder and Meade given a user-defined objective 
c     function
c
c     Arguments:
c        obj    - the subroutine which contains the objective function;
c                 The subroutine must have the following signature:
c                 obj(x,f,n) - where x is the array of x values to 
c                 evaluate, f holds the function evaluation, and n is
c                 the dimension of the problem. Be sure to declare the
c                 subroutine as external before passing it as an argument
c                 to nm()
c        n      - dimension of the problem
c        x      - double precision x (or array of x), which is the
c                 starting point of the objective function
c        right  - a logical; If true, the user wants a right simplex.
c                 If false, the user wants a regular simplex.
c        sigma  - shrinking coeff   (If -1, a default of 0.5 is used.)  
c        alpha  - reflection coeff  (If -1, a default of 1.0 is used.)
c        beta   - contraction coeff (If -1, a default of 0.5 is used.)
c        gamma  - expansion coeff   (If -1, a default of 2.0 is used.)
c        step1  - the starting edgelengths of the simplex. If the
c                 simplex is regular, only one value is required.
c                 An array of n edgelengths is required for a right 
c                 simplex. Set the first element to -1 to use the
c                 default values of 2.0 for the edgelengths.
c        step2  - ending step length (If -1, a default of 10E-8 is used)  
c        maxf   - the maximum allowable number of function evaluations
c                 Set to -1 if no maximum is desired.
c        stddev - a logical which tells the library whether or not to
c                 use the standard deviation as a stopping criterion.
c                 If true, program will terminate if standard deviation
c                 is less than step2. If false, program will terminate 
c                 when delta is less than step2.
c                 See Direct Search class design document for more info. 
c        istat  - completion status (always 1, since search algorithms
c                 have no criteria to stop them from going indefinitely)
c        aux    - the array of size n+2 returned from the library; the 
c                 first value is the final step length, the second is 
c                 the minimum function evaluation and the final n 
c                 elements are the x values which correspond
c        iaux   - returns the number of function evaluations required
c
c---------------------------------------------------------------------
c     Declare the external routines
      external nmsch, obj
c     Declare the arguments
      integer n, maxf, iright, stp
      double precision x(*), sigma, alpha, beta, gamma 
      double precision step1(*), step2, aux(*)
      logical right, stddev
c
      if (right) then
         iright = 1
      else
         iright = 0
      endif
      if (stddev) then
         stp = 1
      else
         stp = 0
      endif
      call nmsch(n, x, iright, sigma, alpha, beta, gamma, step1, 
     c     step2, maxf, stp, istat, aux, iaux, obj)
      return
      end
c
      subroutine smd(obj, n, x, right, step1, step2, maxf, stddev, 
     c     istat, aux, iaux)
c---------------------------------------------------------------------
c     This subroutine implements a sequential multidirectional search
c     given a user-defined objective function
c
c     Arguments:
c        obj    - the subroutine which contains the objective function;
c                 The subroutine must have the following signature:
c                 obj(x,f,n) - where x is the array of x values to 
c                 evaluate, f holds the function evaluation, and n is
c                 the dimension of the problem. Be sure to declare the
c                 subroutine as external before passing it as an argument
c                 to smd()
c        n      - dimension of the problem
c        x      - double precision x (or array of x), which is the
c                 starting point of the objective function
c        right  - a logical; If true, the user wants a right simplex.
c                 If false, the user wants a regular simplex. 
c        step1  - the starting edgelengths of the simplex. If the
c                 simplex is regular, only one value is required.
c                 An array of n edgelengths is required for a right 
c                 simplex. Set the first element to -1 to use the
c                 default values of 2.0 for the edgelengths.
c        step2  - ending step length (If -1, a default of 10E-8 is used)
c        maxf   - the maximum allowable number of function evaluations
c                 Set to -1 if no maximum is desired.
c        stddev - a logical which tells the library whether or not to
c                 use the standard deviation as a stopping criterion.
c                 If true, program will terminate if standard deviation
c                 is less than step2. If false, program will terminate 
c                 when delta is less than step2.
c                 See Direct Search class design document for more info. 
c        istat  - completion status (always 1, since search algorithms
c                 have no criteria to stop them from going indefinitely)
c        aux    - the array of size n+2 returned from the library; the 
c                 first value is the final step length, the second is 
c                 the minimum function evaluation and the final n 
c                 elements are the x values which correspond
c        iaux   - returns the number of function evaluations required
c
c---------------------------------------------------------------------
c     Declare the external routines
      external smdsch, obj
c     Declare the arguments
      integer n, maxf, iright, stp
      double precision x(*), step1(*), step2, aux(*)
      logical right, stddev
c
      if (right) then
         iright = 1
      else
         iright = 0
      endif
      if (stddev) then
         stp = 1
      else
         stp = 0
      endif
      call smdsch(n, x, iright, step1, step2, maxf, stp, istat, 
     c     aux, iaux, obj)
      return
      end
